var form = document.getElementById("raja-form");
    
    async function handleSubmit(event) {
      event.preventDefault();
      var status = document.getElementById("status");
      var data = new FormData(event.target);
      fetch(event.target.action, {
        method: form.method,
        body: data,
        headers: {
            'Accept': 'application/json'
        }
      }).then(response => {
        if (response.ok) {
          status.classList.add('success');
          status.innerHTML = "Thanks for contacting Raja Trucking, LLC. We shall respond to you shortly.";
          form.reset()
        } else {
          response.json().then(data => {
            if (Object.hasOwn(data, 'errors')) {
                status.classList.add('error')
              status.innerHTML = data["errors"].map(error => error["message"]).join(", ")
            } else {
                status.classList.add('error')
              status.innerHTML = "Sorry, there was a problem submitting your form, please try again later."
            }
          })
        }
      }).catch(error => {
          status.classList.add('error');
        status.innerHTML = "Sorry,there was a problem submitting your form. Please try again later."
      });
    }
    form.addEventListener("submit", handleSubmit)



